<?php

namespace App\Database\Migrations;

use CodeIgniter\Database\Migration;

class AddFieldsToGaleriGuruStaf extends Migration
{
    public function up()
    {
        $this->forge->addColumn('galeri_guru_staf', [
            'jabatan_utama' => [
                'type' => 'VARCHAR',
                'constraint' => 120,
                'null' => true,
                'after' => 'nip',
            ],
            'jabatan_tambahan' => [
                'type' => 'TEXT',
                'null' => true,
                'after' => 'jabatan_utama',
            ],
            'mapel' => [
                'type' => 'VARCHAR',
                'constraint' => 120,
                'null' => true,
                'after' => 'jabatan_tambahan',
            ],
        ]);
    }

    public function down()
    {
        $this->forge->dropColumn('galeri_guru_staf', ['jabatan_utama','jabatan_tambahan','mapel']);
    }
}
